/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_hostname_to_nic_id.c,v 1.6 2006/02/12 18:59:55 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__driver_interface.h"
#include "mx__fops.h"
#include "mx__error.h"

MX_FUNC(mx_return_t)
mx_hostname_to_nic_id(char *hostname,
		      uint64_t *nic_id)
{
  mx_return_t r = MX_SUCCESS;
  mx_endpt_handle_t handle;
  mx_nic_id_hostname_t x;

  if (mx__opt.no_myrinet) {
    if (strcmp(hostname, "localhost:0") == 0) {
      *nic_id = UINT64_C(0x123456789abc);
      return MX_SUCCESS;
    } else {
      r = MX_HOST_NOT_FOUND;
      goto abort_with_nothing;
    }
  }
  if ((r = mx_open_any_board(&handle)) != MX_SUCCESS) {
    goto abort_with_nothing;
  }

  x.va = (uint64_t)(uintptr_t)hostname;
  x.len = (uint32_t)mx_strlen(hostname) + 1;
  if (mx__hostname_to_nic_id(handle, &x) != 0) {
    r = MX_HOST_NOT_FOUND;
  } else {
    nic_id[0] = x.nic_id;
  }
  
  mx__close(handle);  

 abort_with_nothing:
  return mx__error_noep("mx_hostname_to_nic_id(%s)", r, hostname);
}

MX_FUNC(mx_return_t)
mx_nic_id_to_hostname(uint64_t nic_id,
		      char *hostname)
{
  mx_return_t r = MX_SUCCESS;
  mx_endpt_handle_t handle;
  mx_nic_id_hostname_t x;

  if (mx__opt.no_myrinet && nic_id == UINT64_C(0x123456789abc)) {
    strcpy(hostname, "localhost:0");
    return MX_SUCCESS;
  }
  if ((r = mx_open_any_board(&handle)) != MX_SUCCESS) {
    goto abort_with_nothing;
  }

  x.nic_id = nic_id;
  x.va = (uint64_t)(uintptr_t)hostname;
  x.len = MX_MAX_HOSTNAME_LEN;
  if (mx__nic_id_to_hostname(handle, &x) != 0) {
    r = MX_HOST_NOT_FOUND;
  }
  
  mx__close(handle);
 abort_with_nothing:
  return mx__error_noep("mx_nic_id_to_hostname(%"PRIx64")", r, nic_id);
}
